// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The information type keyword. </summary>
    public partial class InformationProtectionKeyword
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InformationProtectionKeyword"/>. </summary>
        public InformationProtectionKeyword()
        {
        }

        /// <summary> Initializes a new instance of <see cref="InformationProtectionKeyword"/>. </summary>
        /// <param name="pattern"> The keyword pattern. </param>
        /// <param name="custom"> Indicates whether the keyword is custom or not. </param>
        /// <param name="canBeNumeric"> Indicates whether the keyword can be applied on numeric types or not. </param>
        /// <param name="excluded"> Indicates whether the keyword is excluded or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InformationProtectionKeyword(string pattern, bool? custom, bool? canBeNumeric, bool? excluded, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Pattern = pattern;
            Custom = custom;
            CanBeNumeric = canBeNumeric;
            Excluded = excluded;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The keyword pattern. </summary>
        public string Pattern { get; set; }
        /// <summary> Indicates whether the keyword is custom or not. </summary>
        public bool? Custom { get; set; }
        /// <summary> Indicates whether the keyword can be applied on numeric types or not. </summary>
        public bool? CanBeNumeric { get; set; }
        /// <summary> Indicates whether the keyword is excluded or not. </summary>
        public bool? Excluded { get; set; }
    }
}
