// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> State of the service principal and its secret. </summary>
    public readonly partial struct HybridComputeProvisioningState : IEquatable<HybridComputeProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridComputeProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridComputeProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ValidValue = "Valid";
        private const string InvalidValue = "Invalid";
        private const string ExpiredValue = "Expired";

        /// <summary> Valid service principal details. </summary>
        public static HybridComputeProvisioningState Valid { get; } = new HybridComputeProvisioningState(ValidValue);
        /// <summary> Invalid service principal details. </summary>
        public static HybridComputeProvisioningState Invalid { get; } = new HybridComputeProvisioningState(InvalidValue);
        /// <summary> the service principal details are expired. </summary>
        public static HybridComputeProvisioningState Expired { get; } = new HybridComputeProvisioningState(ExpiredValue);
        /// <summary> Determines if two <see cref="HybridComputeProvisioningState"/> values are the same. </summary>
        public static bool operator ==(HybridComputeProvisioningState left, HybridComputeProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridComputeProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(HybridComputeProvisioningState left, HybridComputeProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridComputeProvisioningState"/>. </summary>
        public static implicit operator HybridComputeProvisioningState(string value) => new HybridComputeProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridComputeProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridComputeProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
