// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The status of the health report. </summary>
    public readonly partial struct HealthReportStatusName : IEquatable<HealthReportStatusName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthReportStatusName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthReportStatusName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HealthyValue = "Healthy";
        private const string NotHealthyValue = "NotHealthy";
        private const string NotApplicableValue = "NotApplicable";

        /// <summary> Healthy. </summary>
        public static HealthReportStatusName Healthy { get; } = new HealthReportStatusName(HealthyValue);
        /// <summary> NotHealthy. </summary>
        public static HealthReportStatusName NotHealthy { get; } = new HealthReportStatusName(NotHealthyValue);
        /// <summary> NotApplicable. </summary>
        public static HealthReportStatusName NotApplicable { get; } = new HealthReportStatusName(NotApplicableValue);
        /// <summary> Determines if two <see cref="HealthReportStatusName"/> values are the same. </summary>
        public static bool operator ==(HealthReportStatusName left, HealthReportStatusName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthReportStatusName"/> values are not the same. </summary>
        public static bool operator !=(HealthReportStatusName left, HealthReportStatusName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthReportStatusName"/>. </summary>
        public static implicit operator HealthReportStatusName(string value) => new HealthReportStatusName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthReportStatusName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthReportStatusName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
