// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The status of the health report. </summary>
    public partial class HealthReportStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HealthReportStatus"/>. </summary>
        public HealthReportStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HealthReportStatus"/>. </summary>
        /// <param name="code"> The status of the health report. </param>
        /// <param name="reason"> The reason of the given status. </param>
        /// <param name="lastScannedOn"> The date of when the resource was scanned in the last time. </param>
        /// <param name="statusChangeOn"> The date of when the status of the health report was changed in the last time. </param>
        /// <param name="firstEvaluationOn"> The date of when the resource of the health report was scanned in the first time. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HealthReportStatus(HealthReportStatusName? code, string reason, DateTimeOffset? lastScannedOn, DateTimeOffset? statusChangeOn, DateTimeOffset? firstEvaluationOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Code = code;
            Reason = reason;
            LastScannedOn = lastScannedOn;
            StatusChangeOn = statusChangeOn;
            FirstEvaluationOn = firstEvaluationOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The status of the health report. </summary>
        public HealthReportStatusName? Code { get; set; }
        /// <summary> The reason of the given status. </summary>
        public string Reason { get; }
        /// <summary> The date of when the resource was scanned in the last time. </summary>
        public DateTimeOffset? LastScannedOn { get; }
        /// <summary> The date of when the status of the health report was changed in the last time. </summary>
        public DateTimeOffset? StatusChangeOn { get; }
        /// <summary> The date of when the resource of the health report was scanned in the first time. </summary>
        public DateTimeOffset? FirstEvaluationOn { get; }
    }
}
