// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The platform where the assessed resource resides. </summary>
    public readonly partial struct HealthReportSource : IEquatable<HealthReportSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthReportSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthReportSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureValue = "Azure";
        private const string OnPremiseValue = "OnPremise";
        private const string OnPremiseSqlValue = "OnPremiseSql";

        /// <summary> Resource is in Azure. </summary>
        public static HealthReportSource Azure { get; } = new HealthReportSource(AzureValue);
        /// <summary> Resource in an on premise machine connected to Azure cloud. </summary>
        public static HealthReportSource OnPremise { get; } = new HealthReportSource(OnPremiseValue);
        /// <summary> SQL Resource in an on premise machine connected to Azure cloud. </summary>
        public static HealthReportSource OnPremiseSql { get; } = new HealthReportSource(OnPremiseSqlValue);
        /// <summary> Determines if two <see cref="HealthReportSource"/> values are the same. </summary>
        public static bool operator ==(HealthReportSource left, HealthReportSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthReportSource"/> values are not the same. </summary>
        public static bool operator !=(HealthReportSource left, HealthReportSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthReportSource"/>. </summary>
        public static implicit operator HealthReportSource(string value) => new HealthReportSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthReportSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthReportSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
