// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The governance rule source, what the rule affects, e.g. Assessments. </summary>
    public readonly partial struct GovernanceRuleSourceResourceType : IEquatable<GovernanceRuleSourceResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GovernanceRuleSourceResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GovernanceRuleSourceResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AssessmentsValue = "Assessments";

        /// <summary> The source of the governance rule is assessments. </summary>
        public static GovernanceRuleSourceResourceType Assessments { get; } = new GovernanceRuleSourceResourceType(AssessmentsValue);
        /// <summary> Determines if two <see cref="GovernanceRuleSourceResourceType"/> values are the same. </summary>
        public static bool operator ==(GovernanceRuleSourceResourceType left, GovernanceRuleSourceResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GovernanceRuleSourceResourceType"/> values are not the same. </summary>
        public static bool operator !=(GovernanceRuleSourceResourceType left, GovernanceRuleSourceResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GovernanceRuleSourceResourceType"/>. </summary>
        public static implicit operator GovernanceRuleSourceResourceType(string value) => new GovernanceRuleSourceResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GovernanceRuleSourceResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GovernanceRuleSourceResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
