// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The owner type for the governance rule owner source. </summary>
    public readonly partial struct GovernanceRuleOwnerSourceType : IEquatable<GovernanceRuleOwnerSourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GovernanceRuleOwnerSourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GovernanceRuleOwnerSourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ByTagValue = "ByTag";
        private const string ManuallyValue = "Manually";

        /// <summary> The rule source type defined using resource tag. </summary>
        public static GovernanceRuleOwnerSourceType ByTag { get; } = new GovernanceRuleOwnerSourceType(ByTagValue);
        /// <summary> The rule source type defined manually. </summary>
        public static GovernanceRuleOwnerSourceType Manually { get; } = new GovernanceRuleOwnerSourceType(ManuallyValue);
        /// <summary> Determines if two <see cref="GovernanceRuleOwnerSourceType"/> values are the same. </summary>
        public static bool operator ==(GovernanceRuleOwnerSourceType left, GovernanceRuleOwnerSourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GovernanceRuleOwnerSourceType"/> values are not the same. </summary>
        public static bool operator !=(GovernanceRuleOwnerSourceType left, GovernanceRuleOwnerSourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GovernanceRuleOwnerSourceType"/>. </summary>
        public static implicit operator GovernanceRuleOwnerSourceType(string value) => new GovernanceRuleOwnerSourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GovernanceRuleOwnerSourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GovernanceRuleOwnerSourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
