// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The governance email weekly notification configuration. </summary>
    public partial class GovernanceEmailNotification
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GovernanceEmailNotification"/>. </summary>
        public GovernanceEmailNotification()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GovernanceEmailNotification"/>. </summary>
        /// <param name="isManagerEmailNotificationDisabled"> Exclude manager from weekly email notification. </param>
        /// <param name="isOwnerEmailNotificationDisabled"> Exclude  owner from weekly email notification. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GovernanceEmailNotification(bool? isManagerEmailNotificationDisabled, bool? isOwnerEmailNotificationDisabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsManagerEmailNotificationDisabled = isManagerEmailNotificationDisabled;
            IsOwnerEmailNotificationDisabled = isOwnerEmailNotificationDisabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Exclude manager from weekly email notification. </summary>
        public bool? IsManagerEmailNotificationDisabled { get; set; }
        /// <summary> Exclude  owner from weekly email notification. </summary>
        public bool? IsOwnerEmailNotificationDisabled { get; set; }
    }
}
