// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Microsoft information protection built-in and custom information types, labels, and integration status. </summary>
    public partial class GetSensitivitySettingsResponsePropertiesMipInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GetSensitivitySettingsResponsePropertiesMipInformation"/>. </summary>
        internal GetSensitivitySettingsResponsePropertiesMipInformation()
        {
            Labels = new ChangeTrackingList<MipSensitivityLabel>();
            CustomInfoTypes = new ChangeTrackingList<UserDefinedInformationType>();
            BuiltInInfoTypes = new ChangeTrackingList<BuiltInInfoType>();
        }

        /// <summary> Initializes a new instance of <see cref="GetSensitivitySettingsResponsePropertiesMipInformation"/>. </summary>
        /// <param name="mipIntegrationStatus"> Microsoft information protection integration status. </param>
        /// <param name="labels"> List of Microsoft information protection sensitivity labels. </param>
        /// <param name="customInfoTypes"> List of custom user-defined information types. </param>
        /// <param name="builtInInfoTypes"> List of pre-configured sensitive information types. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GetSensitivitySettingsResponsePropertiesMipInformation(MipIntegrationStatus? mipIntegrationStatus, IReadOnlyList<MipSensitivityLabel> labels, IReadOnlyList<UserDefinedInformationType> customInfoTypes, IReadOnlyList<BuiltInInfoType> builtInInfoTypes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MipIntegrationStatus = mipIntegrationStatus;
            Labels = labels;
            CustomInfoTypes = customInfoTypes;
            BuiltInInfoTypes = builtInInfoTypes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Microsoft information protection integration status. </summary>
        public MipIntegrationStatus? MipIntegrationStatus { get; }
        /// <summary> List of Microsoft information protection sensitivity labels. </summary>
        public IReadOnlyList<MipSensitivityLabel> Labels { get; }
        /// <summary> List of custom user-defined information types. </summary>
        public IReadOnlyList<UserDefinedInformationType> CustomInfoTypes { get; }
        /// <summary> List of pre-configured sensitive information types. </summary>
        public IReadOnlyList<BuiltInInfoType> BuiltInInfoTypes { get; }
    }
}
