// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class GetSensitivitySettingsResponsePropertiesMipInformation : IUtf8JsonSerializable, IJsonModel<GetSensitivitySettingsResponsePropertiesMipInformation>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<GetSensitivitySettingsResponsePropertiesMipInformation>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<GetSensitivitySettingsResponsePropertiesMipInformation>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetSensitivitySettingsResponsePropertiesMipInformation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GetSensitivitySettingsResponsePropertiesMipInformation)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(MipIntegrationStatus))
            {
                writer.WritePropertyName("mipIntegrationStatus"u8);
                writer.WriteStringValue(MipIntegrationStatus.Value.ToString());
            }
            if (Optional.IsCollectionDefined(Labels))
            {
                writer.WritePropertyName("labels"u8);
                writer.WriteStartArray();
                foreach (var item in Labels)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(CustomInfoTypes))
            {
                writer.WritePropertyName("customInfoTypes"u8);
                writer.WriteStartArray();
                foreach (var item in CustomInfoTypes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(BuiltInInfoTypes))
            {
                writer.WritePropertyName("builtInInfoTypes"u8);
                writer.WriteStartArray();
                foreach (var item in BuiltInInfoTypes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        GetSensitivitySettingsResponsePropertiesMipInformation IJsonModel<GetSensitivitySettingsResponsePropertiesMipInformation>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetSensitivitySettingsResponsePropertiesMipInformation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GetSensitivitySettingsResponsePropertiesMipInformation)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeGetSensitivitySettingsResponsePropertiesMipInformation(document.RootElement, options);
        }

        internal static GetSensitivitySettingsResponsePropertiesMipInformation DeserializeGetSensitivitySettingsResponsePropertiesMipInformation(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MipIntegrationStatus? mipIntegrationStatus = default;
            IReadOnlyList<MipSensitivityLabel> labels = default;
            IReadOnlyList<UserDefinedInformationType> customInfoTypes = default;
            IReadOnlyList<BuiltInInfoType> builtInInfoTypes = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("mipIntegrationStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mipIntegrationStatus = new MipIntegrationStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("labels"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MipSensitivityLabel> array = new List<MipSensitivityLabel>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MipSensitivityLabel.DeserializeMipSensitivityLabel(item, options));
                    }
                    labels = array;
                    continue;
                }
                if (property.NameEquals("customInfoTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<UserDefinedInformationType> array = new List<UserDefinedInformationType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(UserDefinedInformationType.DeserializeUserDefinedInformationType(item, options));
                    }
                    customInfoTypes = array;
                    continue;
                }
                if (property.NameEquals("builtInInfoTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BuiltInInfoType> array = new List<BuiltInInfoType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BuiltInInfoType.DeserializeBuiltInInfoType(item, options));
                    }
                    builtInInfoTypes = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new GetSensitivitySettingsResponsePropertiesMipInformation(mipIntegrationStatus, labels ?? new ChangeTrackingList<MipSensitivityLabel>(), customInfoTypes ?? new ChangeTrackingList<UserDefinedInformationType>(), builtInInfoTypes ?? new ChangeTrackingList<BuiltInInfoType>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<GetSensitivitySettingsResponsePropertiesMipInformation>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetSensitivitySettingsResponsePropertiesMipInformation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(GetSensitivitySettingsResponsePropertiesMipInformation)} does not support writing '{options.Format}' format.");
            }
        }

        GetSensitivitySettingsResponsePropertiesMipInformation IPersistableModel<GetSensitivitySettingsResponsePropertiesMipInformation>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetSensitivitySettingsResponsePropertiesMipInformation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeGetSensitivitySettingsResponsePropertiesMipInformation(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(GetSensitivitySettingsResponsePropertiesMipInformation)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<GetSensitivitySettingsResponsePropertiesMipInformation>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
