// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The GCP project connector environment data. </summary>
    public partial class GcpProjectEnvironment : SecurityConnectorEnvironment
    {
        /// <summary> Initializes a new instance of <see cref="GcpProjectEnvironment"/>. </summary>
        public GcpProjectEnvironment()
        {
            EnvironmentType = EnvironmentType.GcpProject;
        }

        /// <summary> Initializes a new instance of <see cref="GcpProjectEnvironment"/>. </summary>
        /// <param name="environmentType"> The type of the environment data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="organizationalData">
        /// The Gcp project's organizational data
        /// Please note <see cref="GcpOrganizationalInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="GcpMemberOrganizationalInfo"/> and <see cref="GcpParentOrganizationalInfo"/>.
        /// </param>
        /// <param name="projectDetails"> The Gcp project's details. </param>
        /// <param name="scanInterval"> Scan interval in hours (value should be between 1-hour to 24-hours). </param>
        internal GcpProjectEnvironment(EnvironmentType environmentType, IDictionary<string, BinaryData> serializedAdditionalRawData, GcpOrganizationalInfo organizationalData, GcpProjectDetails projectDetails, long? scanInterval) : base(environmentType, serializedAdditionalRawData)
        {
            OrganizationalData = organizationalData;
            ProjectDetails = projectDetails;
            ScanInterval = scanInterval;
            EnvironmentType = environmentType;
        }

        /// <summary>
        /// The Gcp project's organizational data
        /// Please note <see cref="GcpOrganizationalInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="GcpMemberOrganizationalInfo"/> and <see cref="GcpParentOrganizationalInfo"/>.
        /// </summary>
        public GcpOrganizationalInfo OrganizationalData { get; set; }
        /// <summary> The Gcp project's details. </summary>
        public GcpProjectDetails ProjectDetails { get; set; }
        /// <summary> Scan interval in hours (value should be between 1-hour to 24-hours). </summary>
        public long? ScanInterval { get; set; }
    }
}
