// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> GCP cloud account connector based service to service credentials, the credentials are composed of the organization ID and a JSON API key (write only). </summary>
    public partial class GcpCredentialsDetailsProperties : AuthenticationDetailsProperties
    {
        /// <summary> Initializes a new instance of <see cref="GcpCredentialsDetailsProperties"/>. </summary>
        /// <param name="organizationId"> The organization ID of the GCP cloud account. </param>
        /// <param name="gcpCredentialType"> Type field of the API key (write only). </param>
        /// <param name="projectId"> Project ID field of the API key (write only). </param>
        /// <param name="privateKeyId"> Private key ID field of the API key (write only). </param>
        /// <param name="privateKey"> Private key field of the API key (write only). </param>
        /// <param name="clientEmail"> Client email field of the API key (write only). </param>
        /// <param name="clientId"> Client ID field of the API key (write only). </param>
        /// <param name="authUri"> Auth URI field of the API key (write only). </param>
        /// <param name="tokenUri"> Token URI field of the API key (write only). </param>
        /// <param name="authProviderX509CertUri"> Auth provider x509 certificate URL field of the API key (write only). </param>
        /// <param name="clientX509CertUri"> Client x509 certificate URL field of the API key (write only). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="organizationId"/>, <paramref name="gcpCredentialType"/>, <paramref name="projectId"/>, <paramref name="privateKeyId"/>, <paramref name="privateKey"/>, <paramref name="clientEmail"/>, <paramref name="clientId"/>, <paramref name="authUri"/>, <paramref name="tokenUri"/>, <paramref name="authProviderX509CertUri"/> or <paramref name="clientX509CertUri"/> is null. </exception>
        public GcpCredentialsDetailsProperties(string organizationId, string gcpCredentialType, string projectId, string privateKeyId, string privateKey, string clientEmail, string clientId, Uri authUri, Uri tokenUri, Uri authProviderX509CertUri, Uri clientX509CertUri)
        {
            Argument.AssertNotNull(organizationId, nameof(organizationId));
            Argument.AssertNotNull(gcpCredentialType, nameof(gcpCredentialType));
            Argument.AssertNotNull(projectId, nameof(projectId));
            Argument.AssertNotNull(privateKeyId, nameof(privateKeyId));
            Argument.AssertNotNull(privateKey, nameof(privateKey));
            Argument.AssertNotNull(clientEmail, nameof(clientEmail));
            Argument.AssertNotNull(clientId, nameof(clientId));
            Argument.AssertNotNull(authUri, nameof(authUri));
            Argument.AssertNotNull(tokenUri, nameof(tokenUri));
            Argument.AssertNotNull(authProviderX509CertUri, nameof(authProviderX509CertUri));
            Argument.AssertNotNull(clientX509CertUri, nameof(clientX509CertUri));

            OrganizationId = organizationId;
            GcpCredentialType = gcpCredentialType;
            ProjectId = projectId;
            PrivateKeyId = privateKeyId;
            PrivateKey = privateKey;
            ClientEmail = clientEmail;
            ClientId = clientId;
            AuthUri = authUri;
            TokenUri = tokenUri;
            AuthProviderX509CertUri = authProviderX509CertUri;
            ClientX509CertUri = clientX509CertUri;
            AuthenticationType = AuthenticationType.GcpCredentials;
        }

        /// <summary> Initializes a new instance of <see cref="GcpCredentialsDetailsProperties"/>. </summary>
        /// <param name="authenticationProvisioningState"> State of the multi-cloud connector. </param>
        /// <param name="grantedPermissions"> The permissions detected in the cloud account. </param>
        /// <param name="authenticationType"> Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="organizationId"> The organization ID of the GCP cloud account. </param>
        /// <param name="gcpCredentialType"> Type field of the API key (write only). </param>
        /// <param name="projectId"> Project ID field of the API key (write only). </param>
        /// <param name="privateKeyId"> Private key ID field of the API key (write only). </param>
        /// <param name="privateKey"> Private key field of the API key (write only). </param>
        /// <param name="clientEmail"> Client email field of the API key (write only). </param>
        /// <param name="clientId"> Client ID field of the API key (write only). </param>
        /// <param name="authUri"> Auth URI field of the API key (write only). </param>
        /// <param name="tokenUri"> Token URI field of the API key (write only). </param>
        /// <param name="authProviderX509CertUri"> Auth provider x509 certificate URL field of the API key (write only). </param>
        /// <param name="clientX509CertUri"> Client x509 certificate URL field of the API key (write only). </param>
        internal GcpCredentialsDetailsProperties(AuthenticationProvisioningState? authenticationProvisioningState, IReadOnlyList<SecurityCenterCloudPermission> grantedPermissions, AuthenticationType authenticationType, IDictionary<string, BinaryData> serializedAdditionalRawData, string organizationId, string gcpCredentialType, string projectId, string privateKeyId, string privateKey, string clientEmail, string clientId, Uri authUri, Uri tokenUri, Uri authProviderX509CertUri, Uri clientX509CertUri) : base(authenticationProvisioningState, grantedPermissions, authenticationType, serializedAdditionalRawData)
        {
            OrganizationId = organizationId;
            GcpCredentialType = gcpCredentialType;
            ProjectId = projectId;
            PrivateKeyId = privateKeyId;
            PrivateKey = privateKey;
            ClientEmail = clientEmail;
            ClientId = clientId;
            AuthUri = authUri;
            TokenUri = tokenUri;
            AuthProviderX509CertUri = authProviderX509CertUri;
            ClientX509CertUri = clientX509CertUri;
            AuthenticationType = authenticationType;
        }

        /// <summary> Initializes a new instance of <see cref="GcpCredentialsDetailsProperties"/> for deserialization. </summary>
        internal GcpCredentialsDetailsProperties()
        {
        }

        /// <summary> The organization ID of the GCP cloud account. </summary>
        public string OrganizationId { get; set; }
        /// <summary> Type field of the API key (write only). </summary>
        public string GcpCredentialType { get; set; }
        /// <summary> Project ID field of the API key (write only). </summary>
        public string ProjectId { get; set; }
        /// <summary> Private key ID field of the API key (write only). </summary>
        public string PrivateKeyId { get; set; }
        /// <summary> Private key field of the API key (write only). </summary>
        public string PrivateKey { get; set; }
        /// <summary> Client email field of the API key (write only). </summary>
        public string ClientEmail { get; set; }
        /// <summary> Client ID field of the API key (write only). </summary>
        public string ClientId { get; set; }
        /// <summary> Auth URI field of the API key (write only). </summary>
        public Uri AuthUri { get; set; }
        /// <summary> Token URI field of the API key (write only). </summary>
        public Uri TokenUri { get; set; }
        /// <summary> Auth provider x509 certificate URL field of the API key (write only). </summary>
        public Uri AuthProviderX509CertUri { get; set; }
        /// <summary> Client x509 certificate URL field of the API key (write only). </summary>
        public Uri ClientX509CertUri { get; set; }
    }
}
