// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The kind of the external solution. </summary>
    public readonly partial struct ExternalSecuritySolutionKind : IEquatable<ExternalSecuritySolutionKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExternalSecuritySolutionKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExternalSecuritySolutionKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CefValue = "CEF";
        private const string AtaValue = "ATA";
        private const string AadValue = "AAD";

        /// <summary> CEF. </summary>
        public static ExternalSecuritySolutionKind Cef { get; } = new ExternalSecuritySolutionKind(CefValue);
        /// <summary> ATA. </summary>
        public static ExternalSecuritySolutionKind Ata { get; } = new ExternalSecuritySolutionKind(AtaValue);
        /// <summary> AAD. </summary>
        public static ExternalSecuritySolutionKind Aad { get; } = new ExternalSecuritySolutionKind(AadValue);
        /// <summary> Determines if two <see cref="ExternalSecuritySolutionKind"/> values are the same. </summary>
        public static bool operator ==(ExternalSecuritySolutionKind left, ExternalSecuritySolutionKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExternalSecuritySolutionKind"/> values are not the same. </summary>
        public static bool operator !=(ExternalSecuritySolutionKind left, ExternalSecuritySolutionKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExternalSecuritySolutionKind"/>. </summary>
        public static implicit operator ExternalSecuritySolutionKind(string value) => new ExternalSecuritySolutionKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExternalSecuritySolutionKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExternalSecuritySolutionKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
