// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The type of the environment data. </summary>
    internal readonly partial struct EnvironmentType : IEquatable<EnvironmentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnvironmentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnvironmentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AwsAccountValue = "AwsAccount";
        private const string GcpProjectValue = "GcpProject";
        private const string GithubScopeValue = "GithubScope";
        private const string AzureDevOpsScopeValue = "AzureDevOpsScope";
        private const string GitlabScopeValue = "GitlabScope";

        /// <summary> AwsAccount. </summary>
        public static EnvironmentType AwsAccount { get; } = new EnvironmentType(AwsAccountValue);
        /// <summary> GcpProject. </summary>
        public static EnvironmentType GcpProject { get; } = new EnvironmentType(GcpProjectValue);
        /// <summary> GithubScope. </summary>
        public static EnvironmentType GithubScope { get; } = new EnvironmentType(GithubScopeValue);
        /// <summary> AzureDevOpsScope. </summary>
        public static EnvironmentType AzureDevOpsScope { get; } = new EnvironmentType(AzureDevOpsScopeValue);
        /// <summary> GitlabScope. </summary>
        public static EnvironmentType GitlabScope { get; } = new EnvironmentType(GitlabScopeValue);
        /// <summary> Determines if two <see cref="EnvironmentType"/> values are the same. </summary>
        public static bool operator ==(EnvironmentType left, EnvironmentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnvironmentType"/> values are not the same. </summary>
        public static bool operator !=(EnvironmentType left, EnvironmentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnvironmentType"/>. </summary>
        public static implicit operator EnvironmentType(string value) => new EnvironmentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnvironmentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnvironmentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
