// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class EnvironmentDetails : IUtf8JsonSerializable, IJsonModel<EnvironmentDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EnvironmentDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EnvironmentDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnvironmentDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EnvironmentDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(NativeResourceId))
            {
                writer.WritePropertyName("nativeResourceId"u8);
                writer.WriteStringValue(NativeResourceId);
            }
            if (Optional.IsDefined(EnvironmentHierarchyId))
            {
                writer.WritePropertyName("environmentHierarchyId"u8);
                writer.WriteStringValue(EnvironmentHierarchyId);
            }
            if (Optional.IsDefined(OrganizationalHierarchyId))
            {
                writer.WritePropertyName("organizationalHierarchyId"u8);
                writer.WriteStringValue(OrganizationalHierarchyId);
            }
            if (Optional.IsDefined(SubscriptionId))
            {
                writer.WritePropertyName("subscriptionId"u8);
                writer.WriteStringValue(SubscriptionId);
            }
            if (Optional.IsDefined(TenantId))
            {
                writer.WritePropertyName("tenantId"u8);
                writer.WriteStringValue(TenantId.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EnvironmentDetails IJsonModel<EnvironmentDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnvironmentDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EnvironmentDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEnvironmentDetails(document.RootElement, options);
        }

        internal static EnvironmentDetails DeserializeEnvironmentDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier nativeResourceId = default;
            string environmentHierarchyId = default;
            string organizationalHierarchyId = default;
            string subscriptionId = default;
            Guid? tenantId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("nativeResourceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nativeResourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("environmentHierarchyId"u8))
                {
                    environmentHierarchyId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("organizationalHierarchyId"u8))
                {
                    organizationalHierarchyId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subscriptionId"u8))
                {
                    subscriptionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tenantId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tenantId = property.Value.GetGuid();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EnvironmentDetails(
                nativeResourceId,
                environmentHierarchyId,
                organizationalHierarchyId,
                subscriptionId,
                tenantId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<EnvironmentDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnvironmentDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(EnvironmentDetails)} does not support writing '{options.Format}' format.");
            }
        }

        EnvironmentDetails IPersistableModel<EnvironmentDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnvironmentDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEnvironmentDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EnvironmentDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EnvironmentDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
