// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> End of support status. </summary>
    public readonly partial struct EndOfSupportStatus : IEquatable<EndOfSupportStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EndOfSupportStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EndOfSupportStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string NoLongerSupportedValue = "noLongerSupported";
        private const string VersionNoLongerSupportedValue = "versionNoLongerSupported";
        private const string UpcomingNoLongerSupportedValue = "upcomingNoLongerSupported";
        private const string UpcomingVersionNoLongerSupportedValue = "upcomingVersionNoLongerSupported";

        /// <summary> None. </summary>
        public static EndOfSupportStatus None { get; } = new EndOfSupportStatus(NoneValue);
        /// <summary> noLongerSupported. </summary>
        public static EndOfSupportStatus NoLongerSupported { get; } = new EndOfSupportStatus(NoLongerSupportedValue);
        /// <summary> versionNoLongerSupported. </summary>
        public static EndOfSupportStatus VersionNoLongerSupported { get; } = new EndOfSupportStatus(VersionNoLongerSupportedValue);
        /// <summary> upcomingNoLongerSupported. </summary>
        public static EndOfSupportStatus UpcomingNoLongerSupported { get; } = new EndOfSupportStatus(UpcomingNoLongerSupportedValue);
        /// <summary> upcomingVersionNoLongerSupported. </summary>
        public static EndOfSupportStatus UpcomingVersionNoLongerSupported { get; } = new EndOfSupportStatus(UpcomingVersionNoLongerSupportedValue);
        /// <summary> Determines if two <see cref="EndOfSupportStatus"/> values are the same. </summary>
        public static bool operator ==(EndOfSupportStatus left, EndOfSupportStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EndOfSupportStatus"/> values are not the same. </summary>
        public static bool operator !=(EndOfSupportStatus left, EndOfSupportStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EndOfSupportStatus"/>. </summary>
        public static implicit operator EndOfSupportStatus(string value) => new EndOfSupportStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EndOfSupportStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EndOfSupportStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
