// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Describes the Network Security Groups effective on a network interface. </summary>
    public partial class EffectiveNetworkSecurityGroups
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EffectiveNetworkSecurityGroups"/>. </summary>
        public EffectiveNetworkSecurityGroups()
        {
            NetworkSecurityGroups = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="EffectiveNetworkSecurityGroups"/>. </summary>
        /// <param name="networkInterface"> The Azure resource ID of the network interface. </param>
        /// <param name="networkSecurityGroups"> The Network Security Groups effective on the network interface. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EffectiveNetworkSecurityGroups(string networkInterface, IList<string> networkSecurityGroups, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NetworkInterface = networkInterface;
            NetworkSecurityGroups = networkSecurityGroups;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Azure resource ID of the network interface. </summary>
        public string NetworkInterface { get; set; }
        /// <summary> The Network Security Groups effective on the network interface. </summary>
        public IList<string> NetworkSecurityGroups { get; }
    }
}
