// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The DiscoveredSecuritySolution. </summary>
    public partial class DiscoveredSecuritySolution : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiscoveredSecuritySolution"/>. </summary>
        /// <param name="securityFamily"> The security family of the discovered solution. </param>
        /// <param name="offer"> The security solutions' image offer. </param>
        /// <param name="publisher"> The security solutions' image publisher. </param>
        /// <param name="sku"> The security solutions' image sku. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="offer"/>, <paramref name="publisher"/> or <paramref name="sku"/> is null. </exception>
        public DiscoveredSecuritySolution(SecurityFamily securityFamily, string offer, string publisher, string sku)
        {
            Argument.AssertNotNull(offer, nameof(offer));
            Argument.AssertNotNull(publisher, nameof(publisher));
            Argument.AssertNotNull(sku, nameof(sku));

            SecurityFamily = securityFamily;
            Offer = offer;
            Publisher = publisher;
            Sku = sku;
        }

        /// <summary> Initializes a new instance of <see cref="DiscoveredSecuritySolution"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="securityFamily"> The security family of the discovered solution. </param>
        /// <param name="offer"> The security solutions' image offer. </param>
        /// <param name="publisher"> The security solutions' image publisher. </param>
        /// <param name="sku"> The security solutions' image sku. </param>
        /// <param name="location"> Location where the resource is stored. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiscoveredSecuritySolution(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, SecurityFamily securityFamily, string offer, string publisher, string sku, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            SecurityFamily = securityFamily;
            Offer = offer;
            Publisher = publisher;
            Sku = sku;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DiscoveredSecuritySolution"/> for deserialization. </summary>
        internal DiscoveredSecuritySolution()
        {
        }

        /// <summary> The security family of the discovered solution. </summary>
        public SecurityFamily SecurityFamily { get; set; }
        /// <summary> The security solutions' image offer. </summary>
        public string Offer { get; set; }
        /// <summary> The security solutions' image publisher. </summary>
        public string Publisher { get; set; }
        /// <summary> The security solutions' image sku. </summary>
        public string Sku { get; set; }
        /// <summary> Location where the resource is stored. </summary>
        public AzureLocation? Location { get; }
    }
}
