// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Azure DevOps Repository properties. </summary>
    public partial class DevOpsRepositoryProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevOpsRepositoryProperties"/>. </summary>
        public DevOpsRepositoryProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevOpsRepositoryProperties"/>. </summary>
        /// <param name="provisioningStatusMessage"> Gets or sets resource status message. </param>
        /// <param name="provisioningStatusUpdatedOn"> Gets or sets time when resource was last checked. </param>
        /// <param name="provisioningState">
        /// The provisioning state of the resource.
        ///
        /// Pending - Provisioning pending.
        /// Failed - Provisioning failed.
        /// Succeeded - Successful provisioning.
        /// Canceled - Provisioning canceled.
        /// PendingDeletion - Deletion pending.
        /// DeletionSuccess - Deletion successful.
        /// DeletionFailure - Deletion failure.
        /// </param>
        /// <param name="parentOrgName"> Gets or sets parent Azure DevOps Organization name. </param>
        /// <param name="parentProjectName"> Gets or sets parent Azure DevOps Project name. </param>
        /// <param name="repoId"> Gets or sets Azure DevOps Repository id. </param>
        /// <param name="repoUri"> Gets or sets Azure DevOps Repository url. </param>
        /// <param name="visibility"> Gets or sets Azure DevOps repository visibility, whether it is public or private etc. </param>
        /// <param name="onboardingState">
        /// Details about resource onboarding status across all connectors.
        ///
        /// OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
        /// Onboarded - this resource has already been onboarded by the specified connector.
        /// NotOnboarded - this resource has not been onboarded to any connector.
        /// NotApplicable - the onboarding state is not applicable to the current endpoint.
        /// </param>
        /// <param name="actionableRemediation"> Configuration payload for PR Annotations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevOpsRepositoryProperties(string provisioningStatusMessage, DateTimeOffset? provisioningStatusUpdatedOn, DevOpsProvisioningState? provisioningState, string parentOrgName, string parentProjectName, string repoId, Uri repoUri, string visibility, ResourceOnboardingState? onboardingState, ActionableRemediation actionableRemediation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningStatusMessage = provisioningStatusMessage;
            ProvisioningStatusUpdatedOn = provisioningStatusUpdatedOn;
            ProvisioningState = provisioningState;
            ParentOrgName = parentOrgName;
            ParentProjectName = parentProjectName;
            RepoId = repoId;
            RepoUri = repoUri;
            Visibility = visibility;
            OnboardingState = onboardingState;
            ActionableRemediation = actionableRemediation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets resource status message. </summary>
        public string ProvisioningStatusMessage { get; }
        /// <summary> Gets or sets time when resource was last checked. </summary>
        public DateTimeOffset? ProvisioningStatusUpdatedOn { get; }
        /// <summary>
        /// The provisioning state of the resource.
        ///
        /// Pending - Provisioning pending.
        /// Failed - Provisioning failed.
        /// Succeeded - Successful provisioning.
        /// Canceled - Provisioning canceled.
        /// PendingDeletion - Deletion pending.
        /// DeletionSuccess - Deletion successful.
        /// DeletionFailure - Deletion failure.
        /// </summary>
        public DevOpsProvisioningState? ProvisioningState { get; set; }
        /// <summary> Gets or sets parent Azure DevOps Organization name. </summary>
        public string ParentOrgName { get; set; }
        /// <summary> Gets or sets parent Azure DevOps Project name. </summary>
        public string ParentProjectName { get; set; }
        /// <summary> Gets or sets Azure DevOps Repository id. </summary>
        public string RepoId { get; }
        /// <summary> Gets or sets Azure DevOps Repository url. </summary>
        public Uri RepoUri { get; }
        /// <summary> Gets or sets Azure DevOps repository visibility, whether it is public or private etc. </summary>
        public string Visibility { get; }
        /// <summary>
        /// Details about resource onboarding status across all connectors.
        ///
        /// OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
        /// Onboarded - this resource has already been onboarded by the specified connector.
        /// NotOnboarded - this resource has not been onboarded to any connector.
        /// NotApplicable - the onboarding state is not applicable to the current endpoint.
        /// </summary>
        public ResourceOnboardingState? OnboardingState { get; set; }
        /// <summary> Configuration payload for PR Annotations. </summary>
        public ActionableRemediation ActionableRemediation { get; set; }
    }
}
