// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> AutoDiscovery states. </summary>
    public readonly partial struct DevOpsAutoDiscovery : IEquatable<DevOpsAutoDiscovery>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevOpsAutoDiscovery"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevOpsAutoDiscovery(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";
        private const string NotApplicableValue = "NotApplicable";

        /// <summary> Disabled. </summary>
        public static DevOpsAutoDiscovery Disabled { get; } = new DevOpsAutoDiscovery(DisabledValue);
        /// <summary> Enabled. </summary>
        public static DevOpsAutoDiscovery Enabled { get; } = new DevOpsAutoDiscovery(EnabledValue);
        /// <summary> NotApplicable. </summary>
        public static DevOpsAutoDiscovery NotApplicable { get; } = new DevOpsAutoDiscovery(NotApplicableValue);
        /// <summary> Determines if two <see cref="DevOpsAutoDiscovery"/> values are the same. </summary>
        public static bool operator ==(DevOpsAutoDiscovery left, DevOpsAutoDiscovery right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevOpsAutoDiscovery"/> values are not the same. </summary>
        public static bool operator !=(DevOpsAutoDiscovery left, DevOpsAutoDiscovery right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevOpsAutoDiscovery"/>. </summary>
        public static implicit operator DevOpsAutoDiscovery(string value) => new DevOpsAutoDiscovery(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevOpsAutoDiscovery other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevOpsAutoDiscovery other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
