// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> A custom alert rule that checks if a value (depends on the custom alert type) is denied. </summary>
    public partial class DenylistCustomAlertRule : ListCustomAlertRule
    {
        /// <summary> Initializes a new instance of <see cref="DenylistCustomAlertRule"/>. </summary>
        /// <param name="isEnabled"> Status of the custom alert. </param>
        /// <param name="denylistValues"> The values to deny. The format of the values depends on the rule type. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="denylistValues"/> is null. </exception>
        public DenylistCustomAlertRule(bool isEnabled, IEnumerable<string> denylistValues) : base(isEnabled)
        {
            Argument.AssertNotNull(denylistValues, nameof(denylistValues));

            DenylistValues = denylistValues.ToList();
            RuleType = "DenylistCustomAlertRule";
        }

        /// <summary> Initializes a new instance of <see cref="DenylistCustomAlertRule"/>. </summary>
        /// <param name="displayName"> The display name of the custom alert. </param>
        /// <param name="description"> The description of the custom alert. </param>
        /// <param name="isEnabled"> Status of the custom alert. </param>
        /// <param name="ruleType"> The type of the custom alert rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="valueType"> The value type of the items in the list. </param>
        /// <param name="denylistValues"> The values to deny. The format of the values depends on the rule type. </param>
        internal DenylistCustomAlertRule(string displayName, string description, bool isEnabled, string ruleType, IDictionary<string, BinaryData> serializedAdditionalRawData, SecurityValueType? valueType, IList<string> denylistValues) : base(displayName, description, isEnabled, ruleType, serializedAdditionalRawData, valueType)
        {
            DenylistValues = denylistValues;
            RuleType = ruleType ?? "DenylistCustomAlertRule";
        }

        /// <summary> Initializes a new instance of <see cref="DenylistCustomAlertRule"/> for deserialization. </summary>
        internal DenylistCustomAlertRule()
        {
        }

        /// <summary> The values to deny. The format of the values depends on the rule type. </summary>
        public IList<string> DenylistValues { get; }
    }
}
