// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The DefenderForStorageSettingName. </summary>
    public readonly partial struct DefenderForStorageSettingName : IEquatable<DefenderForStorageSettingName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DefenderForStorageSettingName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DefenderForStorageSettingName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CurrentValue = "current";

        /// <summary> Name of the Defender for Storage Settings name. </summary>
        public static DefenderForStorageSettingName Current { get; } = new DefenderForStorageSettingName(CurrentValue);
        /// <summary> Determines if two <see cref="DefenderForStorageSettingName"/> values are the same. </summary>
        public static bool operator ==(DefenderForStorageSettingName left, DefenderForStorageSettingName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DefenderForStorageSettingName"/> values are not the same. </summary>
        public static bool operator !=(DefenderForStorageSettingName left, DefenderForStorageSettingName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DefenderForStorageSettingName"/>. </summary>
        public static implicit operator DefenderForStorageSettingName(string value) => new DefenderForStorageSettingName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DefenderForStorageSettingName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DefenderForStorageSettingName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
