// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The scanning mode for the VM scan. </summary>
    public readonly partial struct DefenderForServersScanningMode : IEquatable<DefenderForServersScanningMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DefenderForServersScanningMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DefenderForServersScanningMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";

        /// <summary> Default. </summary>
        public static DefenderForServersScanningMode Default { get; } = new DefenderForServersScanningMode(DefaultValue);
        /// <summary> Determines if two <see cref="DefenderForServersScanningMode"/> values are the same. </summary>
        public static bool operator ==(DefenderForServersScanningMode left, DefenderForServersScanningMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DefenderForServersScanningMode"/> values are not the same. </summary>
        public static bool operator !=(DefenderForServersScanningMode left, DefenderForServersScanningMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DefenderForServersScanningMode"/>. </summary>
        public static implicit operator DefenderForServersScanningMode(string value) => new DefenderForServersScanningMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DefenderForServersScanningMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DefenderForServersScanningMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
