// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The Vulnerability Assessment autoprovisioning configuration. </summary>
    public partial class DefenderForServersAwsOfferingVulnerabilityAssessmentAutoProvisioning
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DefenderForServersAwsOfferingVulnerabilityAssessmentAutoProvisioning"/>. </summary>
        public DefenderForServersAwsOfferingVulnerabilityAssessmentAutoProvisioning()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DefenderForServersAwsOfferingVulnerabilityAssessmentAutoProvisioning"/>. </summary>
        /// <param name="isEnabled"> Is Vulnerability Assessment auto provisioning enabled. </param>
        /// <param name="configuration"> configuration for Vulnerability Assessment autoprovisioning. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DefenderForServersAwsOfferingVulnerabilityAssessmentAutoProvisioning(bool? isEnabled, DefenderForServersAwsOfferingVulnerabilityAssessmentAutoProvisioningConfiguration configuration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            Configuration = configuration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Is Vulnerability Assessment auto provisioning enabled. </summary>
        public bool? IsEnabled { get; set; }
        /// <summary> configuration for Vulnerability Assessment autoprovisioning. </summary>
        internal DefenderForServersAwsOfferingVulnerabilityAssessmentAutoProvisioningConfiguration Configuration { get; set; }
        /// <summary> The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'. </summary>
        public VulnerabilityAssessmentAutoProvisioningType? VulnerabilityAssessmentAutoProvisioningType
        {
            get => Configuration is null ? default : Configuration.VulnerabilityAssessmentAutoProvisioningType;
            set
            {
                if (Configuration is null)
                    Configuration = new DefenderForServersAwsOfferingVulnerabilityAssessmentAutoProvisioningConfiguration();
                Configuration.VulnerabilityAssessmentAutoProvisioningType = value;
            }
        }
    }
}
