// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The ARC autoprovisioning configuration. </summary>
    public partial class DefenderForServersAwsOfferingArcAutoProvisioning
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DefenderForServersAwsOfferingArcAutoProvisioning"/>. </summary>
        public DefenderForServersAwsOfferingArcAutoProvisioning()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DefenderForServersAwsOfferingArcAutoProvisioning"/>. </summary>
        /// <param name="isEnabled"> Is arc auto provisioning enabled. </param>
        /// <param name="cloudRoleArn"> The cloud role ARN in AWS for this feature. </param>
        /// <param name="configuration"> Configuration for servers Arc auto provisioning. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DefenderForServersAwsOfferingArcAutoProvisioning(bool? isEnabled, string cloudRoleArn, DefenderForServersAwsOfferingArcAutoProvisioningConfiguration configuration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            CloudRoleArn = cloudRoleArn;
            Configuration = configuration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Is arc auto provisioning enabled. </summary>
        public bool? IsEnabled { get; set; }
        /// <summary> The cloud role ARN in AWS for this feature. </summary>
        public string CloudRoleArn { get; set; }
        /// <summary> Configuration for servers Arc auto provisioning. </summary>
        public DefenderForServersAwsOfferingArcAutoProvisioningConfiguration Configuration { get; set; }
    }
}
