// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The Defender for Databases GCP offering configurations. </summary>
    public partial class DefenderForDatabasesGcpOffering : SecurityCenterCloudOffering
    {
        /// <summary> Initializes a new instance of <see cref="DefenderForDatabasesGcpOffering"/>. </summary>
        public DefenderForDatabasesGcpOffering()
        {
            OfferingType = OfferingType.DefenderForDatabasesGcp;
        }

        /// <summary> Initializes a new instance of <see cref="DefenderForDatabasesGcpOffering"/>. </summary>
        /// <param name="offeringType"> The type of the security offering. </param>
        /// <param name="description"> The offering description. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="arcAutoProvisioning"> The ARC autoprovisioning configuration. </param>
        /// <param name="defenderForDatabasesArcAutoProvisioning"> The native cloud connection configuration. </param>
        internal DefenderForDatabasesGcpOffering(OfferingType offeringType, string description, IDictionary<string, BinaryData> serializedAdditionalRawData, DefenderForDatabasesGcpOfferingArcAutoProvisioning arcAutoProvisioning, GcpDefenderForDatabasesArcAutoProvisioning defenderForDatabasesArcAutoProvisioning) : base(offeringType, description, serializedAdditionalRawData)
        {
            ArcAutoProvisioning = arcAutoProvisioning;
            DefenderForDatabasesArcAutoProvisioning = defenderForDatabasesArcAutoProvisioning;
            OfferingType = offeringType;
        }

        /// <summary> The ARC autoprovisioning configuration. </summary>
        public DefenderForDatabasesGcpOfferingArcAutoProvisioning ArcAutoProvisioning { get; set; }
        /// <summary> The native cloud connection configuration. </summary>
        public GcpDefenderForDatabasesArcAutoProvisioning DefenderForDatabasesArcAutoProvisioning { get; set; }
    }
}
