// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The Defender for Containers AWS offering. </summary>
    public partial class DefenderForContainersAwsOffering : SecurityCenterCloudOffering
    {
        /// <summary> Initializes a new instance of <see cref="DefenderForContainersAwsOffering"/>. </summary>
        public DefenderForContainersAwsOffering()
        {
            OfferingType = OfferingType.DefenderForContainersAws;
        }

        /// <summary> Initializes a new instance of <see cref="DefenderForContainersAwsOffering"/>. </summary>
        /// <param name="offeringType"> The type of the security offering. </param>
        /// <param name="description"> The offering description. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="kubernetesService"> The kubernetes service connection configuration. </param>
        /// <param name="kubernetesScubaReader"> The kubernetes to scuba connection configuration. </param>
        /// <param name="cloudWatchToKinesis"> The cloudwatch to kinesis connection configuration. </param>
        /// <param name="kinesisToS3"> The kinesis to s3 connection configuration. </param>
        /// <param name="containerVulnerabilityAssessment"> The container vulnerability assessment configuration. </param>
        /// <param name="containerVulnerabilityAssessmentTask"> The container vulnerability assessment task configuration. </param>
        /// <param name="isContainerVulnerabilityAssessmentEnabled"> Enable container vulnerability assessment feature. </param>
        /// <param name="isAutoProvisioningEnabled"> Is audit logs pipeline auto provisioning enabled. </param>
        /// <param name="kubeAuditRetentionTime"> The retention time in days of kube audit logs set on the CloudWatch log group. </param>
        /// <param name="scubaExternalId"> The externalId used by the data reader to prevent the confused deputy attack. </param>
        /// <param name="mdcContainersImageAssessment"> The Microsoft Defender container image assessment configuration. </param>
        /// <param name="mdcContainersAgentlessDiscoveryK8S"> The Microsoft Defender container agentless discovery K8s configuration. </param>
        internal DefenderForContainersAwsOffering(OfferingType offeringType, string description, IDictionary<string, BinaryData> serializedAdditionalRawData, DefenderForContainersAwsOfferingKubernetesService kubernetesService, DefenderForContainersAwsOfferingKubernetesScubaReader kubernetesScubaReader, DefenderForContainersAwsOfferingCloudWatchToKinesis cloudWatchToKinesis, DefenderForContainersAwsOfferingKinesisToS3 kinesisToS3, DefenderForContainersAwsOfferingContainerVulnerabilityAssessment containerVulnerabilityAssessment, DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask containerVulnerabilityAssessmentTask, bool? isContainerVulnerabilityAssessmentEnabled, bool? isAutoProvisioningEnabled, long? kubeAuditRetentionTime, string scubaExternalId, DefenderForContainersAwsOfferingMdcContainersImageAssessment mdcContainersImageAssessment, DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S mdcContainersAgentlessDiscoveryK8S) : base(offeringType, description, serializedAdditionalRawData)
        {
            KubernetesService = kubernetesService;
            KubernetesScubaReader = kubernetesScubaReader;
            CloudWatchToKinesis = cloudWatchToKinesis;
            KinesisToS3 = kinesisToS3;
            ContainerVulnerabilityAssessment = containerVulnerabilityAssessment;
            ContainerVulnerabilityAssessmentTask = containerVulnerabilityAssessmentTask;
            IsContainerVulnerabilityAssessmentEnabled = isContainerVulnerabilityAssessmentEnabled;
            IsAutoProvisioningEnabled = isAutoProvisioningEnabled;
            KubeAuditRetentionTime = kubeAuditRetentionTime;
            ScubaExternalId = scubaExternalId;
            MdcContainersImageAssessment = mdcContainersImageAssessment;
            MdcContainersAgentlessDiscoveryK8S = mdcContainersAgentlessDiscoveryK8S;
            OfferingType = offeringType;
        }

        /// <summary> The kubernetes service connection configuration. </summary>
        internal DefenderForContainersAwsOfferingKubernetesService KubernetesService { get; set; }
        /// <summary> The cloud role ARN in AWS for this feature used for provisioning resources. </summary>
        public string KubernetesServiceCloudRoleArn
        {
            get => KubernetesService is null ? default : KubernetesService.CloudRoleArn;
            set
            {
                if (KubernetesService is null)
                    KubernetesService = new DefenderForContainersAwsOfferingKubernetesService();
                KubernetesService.CloudRoleArn = value;
            }
        }

        /// <summary> The kubernetes to scuba connection configuration. </summary>
        internal DefenderForContainersAwsOfferingKubernetesScubaReader KubernetesScubaReader { get; set; }
        /// <summary> The cloud role ARN in AWS for this feature used for reading data. </summary>
        public string KubernetesScubaReaderCloudRoleArn
        {
            get => KubernetesScubaReader is null ? default : KubernetesScubaReader.CloudRoleArn;
            set
            {
                if (KubernetesScubaReader is null)
                    KubernetesScubaReader = new DefenderForContainersAwsOfferingKubernetesScubaReader();
                KubernetesScubaReader.CloudRoleArn = value;
            }
        }

        /// <summary> The cloudwatch to kinesis connection configuration. </summary>
        internal DefenderForContainersAwsOfferingCloudWatchToKinesis CloudWatchToKinesis { get; set; }
        /// <summary> The cloud role ARN in AWS used by CloudWatch to transfer data into Kinesis. </summary>
        public string CloudRoleArn
        {
            get => CloudWatchToKinesis is null ? default : CloudWatchToKinesis.CloudRoleArn;
            set
            {
                if (CloudWatchToKinesis is null)
                    CloudWatchToKinesis = new DefenderForContainersAwsOfferingCloudWatchToKinesis();
                CloudWatchToKinesis.CloudRoleArn = value;
            }
        }

        /// <summary> The kinesis to s3 connection configuration. </summary>
        internal DefenderForContainersAwsOfferingKinesisToS3 KinesisToS3 { get; set; }
        /// <summary> The cloud role ARN in AWS used by Kinesis to transfer data into S3. </summary>
        public string KinesisToS3CloudRoleArn
        {
            get => KinesisToS3 is null ? default : KinesisToS3.CloudRoleArn;
            set
            {
                if (KinesisToS3 is null)
                    KinesisToS3 = new DefenderForContainersAwsOfferingKinesisToS3();
                KinesisToS3.CloudRoleArn = value;
            }
        }

        /// <summary> The container vulnerability assessment configuration. </summary>
        internal DefenderForContainersAwsOfferingContainerVulnerabilityAssessment ContainerVulnerabilityAssessment { get; set; }
        /// <summary> The cloud role ARN in AWS for this feature. </summary>
        public string ContainerVulnerabilityAssessmentCloudRoleArn
        {
            get => ContainerVulnerabilityAssessment is null ? default : ContainerVulnerabilityAssessment.CloudRoleArn;
            set
            {
                if (ContainerVulnerabilityAssessment is null)
                    ContainerVulnerabilityAssessment = new DefenderForContainersAwsOfferingContainerVulnerabilityAssessment();
                ContainerVulnerabilityAssessment.CloudRoleArn = value;
            }
        }

        /// <summary> The container vulnerability assessment task configuration. </summary>
        internal DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask ContainerVulnerabilityAssessmentTask { get; set; }
        /// <summary> The cloud role ARN in AWS for this feature. </summary>
        public string ContainerVulnerabilityAssessmentTaskCloudRoleArn
        {
            get => ContainerVulnerabilityAssessmentTask is null ? default : ContainerVulnerabilityAssessmentTask.CloudRoleArn;
            set
            {
                if (ContainerVulnerabilityAssessmentTask is null)
                    ContainerVulnerabilityAssessmentTask = new DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask();
                ContainerVulnerabilityAssessmentTask.CloudRoleArn = value;
            }
        }

        /// <summary> Enable container vulnerability assessment feature. </summary>
        public bool? IsContainerVulnerabilityAssessmentEnabled { get; set; }
        /// <summary> Is audit logs pipeline auto provisioning enabled. </summary>
        public bool? IsAutoProvisioningEnabled { get; set; }
        /// <summary> The retention time in days of kube audit logs set on the CloudWatch log group. </summary>
        public long? KubeAuditRetentionTime { get; set; }
        /// <summary> The externalId used by the data reader to prevent the confused deputy attack. </summary>
        public string ScubaExternalId { get; set; }
        /// <summary> The Microsoft Defender container image assessment configuration. </summary>
        public DefenderForContainersAwsOfferingMdcContainersImageAssessment MdcContainersImageAssessment { get; set; }
        /// <summary> The Microsoft Defender container agentless discovery K8s configuration. </summary>
        public DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S MdcContainersAgentlessDiscoveryK8S { get; set; }
    }
}
