// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Defenders CSPM Cloud infrastructure entitlement management (CIEM) offering configurations. </summary>
    public partial class DefenderCspmAwsOfferingCiem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DefenderCspmAwsOfferingCiem"/>. </summary>
        public DefenderCspmAwsOfferingCiem()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DefenderCspmAwsOfferingCiem"/>. </summary>
        /// <param name="ciemDiscovery"> Defender CSPM CIEM discovery configuration. </param>
        /// <param name="ciemOidc"> Defender CSPM CIEM AWS OIDC (open id connect) configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DefenderCspmAwsOfferingCiem(DefenderCspmAwsOfferingCiemDiscovery ciemDiscovery, DefenderCspmAwsOfferingCiemOidc ciemOidc, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CiemDiscovery = ciemDiscovery;
            CiemOidc = ciemOidc;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Defender CSPM CIEM discovery configuration. </summary>
        internal DefenderCspmAwsOfferingCiemDiscovery CiemDiscovery { get; set; }
        /// <summary> The cloud role ARN in AWS for CIEM discovery. </summary>
        public string CiemDiscoveryCloudRoleArn
        {
            get => CiemDiscovery is null ? default : CiemDiscovery.CloudRoleArn;
            set
            {
                if (CiemDiscovery is null)
                    CiemDiscovery = new DefenderCspmAwsOfferingCiemDiscovery();
                CiemDiscovery.CloudRoleArn = value;
            }
        }

        /// <summary> Defender CSPM CIEM AWS OIDC (open id connect) configuration. </summary>
        public DefenderCspmAwsOfferingCiemOidc CiemOidc { get; set; }
    }
}
