// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The severity to relate to the assessments generated by this assessment automation. </summary>
    public readonly partial struct CustomAssessmentSeverity : IEquatable<CustomAssessmentSeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CustomAssessmentSeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CustomAssessmentSeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HighValue = "High";
        private const string MediumValue = "Medium";
        private const string LowValue = "Low";

        /// <summary> High. </summary>
        public static CustomAssessmentSeverity High { get; } = new CustomAssessmentSeverity(HighValue);
        /// <summary> Medium. </summary>
        public static CustomAssessmentSeverity Medium { get; } = new CustomAssessmentSeverity(MediumValue);
        /// <summary> Low. </summary>
        public static CustomAssessmentSeverity Low { get; } = new CustomAssessmentSeverity(LowValue);
        /// <summary> Determines if two <see cref="CustomAssessmentSeverity"/> values are the same. </summary>
        public static bool operator ==(CustomAssessmentSeverity left, CustomAssessmentSeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CustomAssessmentSeverity"/> values are not the same. </summary>
        public static bool operator !=(CustomAssessmentSeverity left, CustomAssessmentSeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CustomAssessmentSeverity"/>. </summary>
        public static implicit operator CustomAssessmentSeverity(string value) => new CustomAssessmentSeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CustomAssessmentSeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CustomAssessmentSeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
