// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Custom Assessment Automation request. </summary>
    public partial class CustomAssessmentAutomationCreateOrUpdateContent : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CustomAssessmentAutomationCreateOrUpdateContent"/>. </summary>
        public CustomAssessmentAutomationCreateOrUpdateContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CustomAssessmentAutomationCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="compressedQuery"> Base 64 encoded KQL query representing the assessment automation results required. </param>
        /// <param name="supportedCloud"> Relevant cloud for the custom assessment automation. </param>
        /// <param name="severity"> The severity to relate to the assessments generated by this assessment automation. </param>
        /// <param name="displayName"> The display name of the assessments generated by this assessment automation. </param>
        /// <param name="description"> The description to relate to the assessments generated by this assessment automation. </param>
        /// <param name="remediationDescription"> The remediation description to relate to the assessments generated by this assessment automation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CustomAssessmentAutomationCreateOrUpdateContent(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string compressedQuery, CustomAssessmentAutomationSupportedCloud? supportedCloud, CustomAssessmentSeverity? severity, string displayName, string description, string remediationDescription, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            CompressedQuery = compressedQuery;
            SupportedCloud = supportedCloud;
            Severity = severity;
            DisplayName = displayName;
            Description = description;
            RemediationDescription = remediationDescription;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Base 64 encoded KQL query representing the assessment automation results required. </summary>
        public string CompressedQuery { get; set; }
        /// <summary> Relevant cloud for the custom assessment automation. </summary>
        public CustomAssessmentAutomationSupportedCloud? SupportedCloud { get; set; }
        /// <summary> The severity to relate to the assessments generated by this assessment automation. </summary>
        public CustomAssessmentSeverity? Severity { get; set; }
        /// <summary> The display name of the assessments generated by this assessment automation. </summary>
        public string DisplayName { get; set; }
        /// <summary> The description to relate to the assessments generated by this assessment automation. </summary>
        public string Description { get; set; }
        /// <summary> The remediation description to relate to the assessments generated by this assessment automation. </summary>
        public string RemediationDescription { get; set; }
    }
}
