// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Additional context fields for container registry Vulnerability assessment. </summary>
    public partial class ContainerRegistryVulnerabilityProperties : SecuritySubAssessmentAdditionalInfo
    {
        /// <summary> Initializes a new instance of <see cref="ContainerRegistryVulnerabilityProperties"/>. </summary>
        public ContainerRegistryVulnerabilityProperties()
        {
            Cvss = new ChangeTrackingDictionary<string, SecurityCvss>();
            Cve = new ChangeTrackingList<SecurityCve>();
            VendorReferences = new ChangeTrackingList<VendorReference>();
            AssessedResourceType = AssessedResourceType.ContainerRegistryVulnerability;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerRegistryVulnerabilityProperties"/>. </summary>
        /// <param name="assessedResourceType"> Sub-assessment resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="containerRegistryVulnerabilityPropertiesType"> Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered, Vulnerability. </param>
        /// <param name="cvss"> Dictionary from cvss version to cvss details object. </param>
        /// <param name="isPatchable"> Indicates whether a patch is available or not. </param>
        /// <param name="cve"> List of CVEs. </param>
        /// <param name="publishedOn"> Published time. </param>
        /// <param name="vendorReferences"></param>
        /// <param name="repositoryName"> Name of the repository which the vulnerable image belongs to. </param>
        /// <param name="imageDigest"> Digest of the vulnerable image. </param>
        internal ContainerRegistryVulnerabilityProperties(AssessedResourceType assessedResourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string containerRegistryVulnerabilityPropertiesType, IReadOnlyDictionary<string, SecurityCvss> cvss, bool? isPatchable, IReadOnlyList<SecurityCve> cve, DateTimeOffset? publishedOn, IReadOnlyList<VendorReference> vendorReferences, string repositoryName, string imageDigest) : base(assessedResourceType, serializedAdditionalRawData)
        {
            ContainerRegistryVulnerabilityPropertiesType = containerRegistryVulnerabilityPropertiesType;
            Cvss = cvss;
            IsPatchable = isPatchable;
            Cve = cve;
            PublishedOn = publishedOn;
            VendorReferences = vendorReferences;
            RepositoryName = repositoryName;
            ImageDigest = imageDigest;
            AssessedResourceType = assessedResourceType;
        }

        /// <summary> Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered, Vulnerability. </summary>
        public string ContainerRegistryVulnerabilityPropertiesType { get; }
        /// <summary> Dictionary from cvss version to cvss details object. </summary>
        public IReadOnlyDictionary<string, SecurityCvss> Cvss { get; }
        /// <summary> Indicates whether a patch is available or not. </summary>
        public bool? IsPatchable { get; }
        /// <summary> List of CVEs. </summary>
        public IReadOnlyList<SecurityCve> Cve { get; }
        /// <summary> Published time. </summary>
        public DateTimeOffset? PublishedOn { get; }
        /// <summary> Gets the vendor references. </summary>
        public IReadOnlyList<VendorReference> VendorReferences { get; }
        /// <summary> Name of the repository which the vulnerable image belongs to. </summary>
        public string RepositoryName { get; }
        /// <summary> Digest of the vulnerable image. </summary>
        public string ImageDigest { get; }
    }
}
