// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class ContainerRegistryVulnerabilityProperties : IUtf8JsonSerializable, IJsonModel<ContainerRegistryVulnerabilityProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ContainerRegistryVulnerabilityProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ContainerRegistryVulnerabilityProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerRegistryVulnerabilityProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerRegistryVulnerabilityProperties)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ContainerRegistryVulnerabilityPropertiesType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(ContainerRegistryVulnerabilityPropertiesType);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Cvss))
            {
                writer.WritePropertyName("cvss"u8);
                writer.WriteStartObject();
                foreach (var item in Cvss)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteObjectValue(item.Value, options);
                }
                writer.WriteEndObject();
            }
            if (options.Format != "W" && Optional.IsDefined(IsPatchable))
            {
                writer.WritePropertyName("patchable"u8);
                writer.WriteBooleanValue(IsPatchable.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Cve))
            {
                writer.WritePropertyName("cve"u8);
                writer.WriteStartArray();
                foreach (var item in Cve)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(PublishedOn))
            {
                writer.WritePropertyName("publishedTime"u8);
                writer.WriteStringValue(PublishedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(VendorReferences))
            {
                writer.WritePropertyName("vendorReferences"u8);
                writer.WriteStartArray();
                foreach (var item in VendorReferences)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(RepositoryName))
            {
                writer.WritePropertyName("repositoryName"u8);
                writer.WriteStringValue(RepositoryName);
            }
            if (options.Format != "W" && Optional.IsDefined(ImageDigest))
            {
                writer.WritePropertyName("imageDigest"u8);
                writer.WriteStringValue(ImageDigest);
            }
        }

        ContainerRegistryVulnerabilityProperties IJsonModel<ContainerRegistryVulnerabilityProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerRegistryVulnerabilityProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ContainerRegistryVulnerabilityProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeContainerRegistryVulnerabilityProperties(document.RootElement, options);
        }

        internal static ContainerRegistryVulnerabilityProperties DeserializeContainerRegistryVulnerabilityProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string type = default;
            IReadOnlyDictionary<string, SecurityCvss> cvss = default;
            bool? patchable = default;
            IReadOnlyList<SecurityCve> cve = default;
            DateTimeOffset? publishedTime = default;
            IReadOnlyList<VendorReference> vendorReferences = default;
            string repositoryName = default;
            string imageDigest = default;
            AssessedResourceType assessedResourceType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cvss"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, SecurityCvss> dictionary = new Dictionary<string, SecurityCvss>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, SecurityCvss.DeserializeSecurityCvss(property0.Value, options));
                    }
                    cvss = dictionary;
                    continue;
                }
                if (property.NameEquals("patchable"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    patchable = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("cve"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SecurityCve> array = new List<SecurityCve>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SecurityCve.DeserializeSecurityCve(item, options));
                    }
                    cve = array;
                    continue;
                }
                if (property.NameEquals("publishedTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    publishedTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("vendorReferences"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<VendorReference> array = new List<VendorReference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(VendorReference.DeserializeVendorReference(item, options));
                    }
                    vendorReferences = array;
                    continue;
                }
                if (property.NameEquals("repositoryName"u8))
                {
                    repositoryName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("imageDigest"u8))
                {
                    imageDigest = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("assessedResourceType"u8))
                {
                    assessedResourceType = new AssessedResourceType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ContainerRegistryVulnerabilityProperties(
                assessedResourceType,
                serializedAdditionalRawData,
                type,
                cvss ?? new ChangeTrackingDictionary<string, SecurityCvss>(),
                patchable,
                cve ?? new ChangeTrackingList<SecurityCve>(),
                publishedTime,
                vendorReferences ?? new ChangeTrackingList<VendorReference>(),
                repositoryName,
                imageDigest);
        }

        BinaryData IPersistableModel<ContainerRegistryVulnerabilityProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerRegistryVulnerabilityProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ContainerRegistryVulnerabilityProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ContainerRegistryVulnerabilityProperties IPersistableModel<ContainerRegistryVulnerabilityProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ContainerRegistryVulnerabilityProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeContainerRegistryVulnerabilityProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ContainerRegistryVulnerabilityProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ContainerRegistryVulnerabilityProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
