// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The external security solution properties for CEF solutions. </summary>
    public partial class CefSolutionProperties : ExternalSecuritySolutionProperties
    {
        /// <summary> Initializes a new instance of <see cref="CefSolutionProperties"/>. </summary>
        public CefSolutionProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CefSolutionProperties"/>. </summary>
        /// <param name="deviceVendor"></param>
        /// <param name="deviceType"></param>
        /// <param name="workspace"> Represents an OMS workspace to which the solution is connected. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="hostname"></param>
        /// <param name="agent"></param>
        /// <param name="lastEventReceived"></param>
        internal CefSolutionProperties(string deviceVendor, string deviceType, WritableSubResource workspace, IDictionary<string, BinaryData> additionalProperties, string hostname, string agent, string lastEventReceived) : base(deviceVendor, deviceType, workspace, additionalProperties)
        {
            Hostname = hostname;
            Agent = agent;
            LastEventReceived = lastEventReceived;
        }

        /// <summary> Gets or sets the hostname. </summary>
        public string Hostname { get; set; }
        /// <summary> Gets or sets the agent. </summary>
        public string Agent { get; set; }
        /// <summary> Gets or sets the last event received. </summary>
        public string LastEventReceived { get; set; }
    }
}
