// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Represents a security solution which sends CEF logs to an OMS workspace. </summary>
    public partial class CefExternalSecuritySolution : ExternalSecuritySolution
    {
        /// <summary> Initializes a new instance of <see cref="CefExternalSecuritySolution"/>. </summary>
        public CefExternalSecuritySolution()
        {
            Kind = ExternalSecuritySolutionKind.Cef;
        }

        /// <summary> Initializes a new instance of <see cref="CefExternalSecuritySolution"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The kind of the external solution. </param>
        /// <param name="location"> Location where the resource is stored. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> The external security solution properties for CEF solutions. </param>
        internal CefExternalSecuritySolution(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ExternalSecuritySolutionKind? kind, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData, CefSolutionProperties properties) : base(id, name, resourceType, systemData, kind, location, serializedAdditionalRawData)
        {
            Properties = properties;
            Kind = kind;
        }

        /// <summary> The external security solution properties for CEF solutions. </summary>
        public CefSolutionProperties Properties { get; set; }
    }
}
