// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Pre-configured sensitive information type. </summary>
    public partial class BuiltInInfoType
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BuiltInInfoType"/>. </summary>
        internal BuiltInInfoType()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BuiltInInfoType"/>. </summary>
        /// <param name="name"> Display name of the info type. </param>
        /// <param name="id"> Id of the info type. </param>
        /// <param name="builtInInfoTypeValue"> Category of the built-in info type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BuiltInInfoType(string name, Guid? id, string builtInInfoTypeValue, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Id = id;
            BuiltInInfoTypeValue = builtInInfoTypeValue;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Display name of the info type. </summary>
        public string Name { get; }
        /// <summary> Id of the info type. </summary>
        public Guid? Id { get; }
        /// <summary> Category of the built-in info type. </summary>
        public string BuiltInInfoTypeValue { get; }
    }
}
