// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The benchmark references. </summary>
    public partial class BenchmarkReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BenchmarkReference"/>. </summary>
        public BenchmarkReference()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BenchmarkReference"/>. </summary>
        /// <param name="benchmark"> The benchmark name. </param>
        /// <param name="reference"> The benchmark reference. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BenchmarkReference(string benchmark, string reference, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Benchmark = benchmark;
            Reference = reference;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The benchmark name. </summary>
        public string Benchmark { get; set; }
        /// <summary> The benchmark reference. </summary>
        public string Reference { get; set; }
    }
}
