// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The rule result adjusted with baseline. </summary>
    public partial class BaselineAdjustedResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BaselineAdjustedResult"/>. </summary>
        public BaselineAdjustedResult()
        {
            ResultsNotInBaseline = new ChangeTrackingList<IList<string>>();
            ResultsOnlyInBaseline = new ChangeTrackingList<IList<string>>();
        }

        /// <summary> Initializes a new instance of <see cref="BaselineAdjustedResult"/>. </summary>
        /// <param name="baseline"> Baseline details. </param>
        /// <param name="status"> The rule result status. </param>
        /// <param name="resultsNotInBaseline"> Results the are not in baseline. </param>
        /// <param name="resultsOnlyInBaseline"> Results the are in baseline. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BaselineAdjustedResult(SqlVulnerabilityAssessmentBaseline baseline, SqlVulnerabilityAssessmentScanResultRuleStatus? status, IList<IList<string>> resultsNotInBaseline, IList<IList<string>> resultsOnlyInBaseline, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Baseline = baseline;
            Status = status;
            ResultsNotInBaseline = resultsNotInBaseline;
            ResultsOnlyInBaseline = resultsOnlyInBaseline;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Baseline details. </summary>
        public SqlVulnerabilityAssessmentBaseline Baseline { get; set; }
        /// <summary> The rule result status. </summary>
        public SqlVulnerabilityAssessmentScanResultRuleStatus? Status { get; set; }
        /// <summary> Results the are not in baseline. </summary>
        public IList<IList<string>> ResultsNotInBaseline { get; }
        /// <summary> Results the are in baseline. </summary>
        public IList<IList<string>> ResultsOnlyInBaseline { get; }
    }
}
