// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Details of the Azure resource that was assessed. </summary>
    public partial class AzureResourceDetails : SecurityCenterResourceDetails
    {
        /// <summary> Initializes a new instance of <see cref="AzureResourceDetails"/>. </summary>
        public AzureResourceDetails()
        {
            Source = HealthReportSource.Azure;
        }

        /// <summary> Initializes a new instance of <see cref="AzureResourceDetails"/>. </summary>
        /// <param name="source"> The platform where the assessed resource resides. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="id"> Azure resource Id of the assessed resource. </param>
        internal AzureResourceDetails(HealthReportSource source, IDictionary<string, BinaryData> serializedAdditionalRawData, string id) : base(source, serializedAdditionalRawData)
        {
            Id = id;
            Source = source;
        }

        /// <summary> Azure resource Id of the assessed resource. </summary>
        public string Id { get; }
    }
}
