// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The AWS organization data for the master account. </summary>
    public partial class AwsOrganizationalDataMaster : AwsOrganizationalInfo
    {
        /// <summary> Initializes a new instance of <see cref="AwsOrganizationalDataMaster"/>. </summary>
        public AwsOrganizationalDataMaster()
        {
            ExcludedAccountIds = new ChangeTrackingList<string>();
            OrganizationMembershipType = OrganizationMembershipType.Organization;
        }

        /// <summary> Initializes a new instance of <see cref="AwsOrganizationalDataMaster"/>. </summary>
        /// <param name="organizationMembershipType"> The multi cloud account's membership type in the organization. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="stacksetName"> If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset. </param>
        /// <param name="excludedAccountIds"> If the multi cloud account is of membership type organization, list of accounts excluded from offering. </param>
        internal AwsOrganizationalDataMaster(OrganizationMembershipType organizationMembershipType, IDictionary<string, BinaryData> serializedAdditionalRawData, string stacksetName, IList<string> excludedAccountIds) : base(organizationMembershipType, serializedAdditionalRawData)
        {
            StacksetName = stacksetName;
            ExcludedAccountIds = excludedAccountIds;
            OrganizationMembershipType = organizationMembershipType;
        }

        /// <summary> If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset. </summary>
        public string StacksetName { get; set; }
        /// <summary> If the multi cloud account is of membership type organization, list of accounts excluded from offering. </summary>
        public IList<string> ExcludedAccountIds { get; }
    }
}
