// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> AWS cloud account connector based credentials, the credentials is composed of access key ID and secret key, for more details, refer to &lt;a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html"&gt;Creating an IAM User in Your AWS Account (write only)&lt;/a&gt;. </summary>
    public partial class AwsCredsAuthenticationDetailsProperties : AuthenticationDetailsProperties
    {
        /// <summary> Initializes a new instance of <see cref="AwsCredsAuthenticationDetailsProperties"/>. </summary>
        /// <param name="awsAccessKeyId"> Public key element of the AWS credential object (write only). </param>
        /// <param name="awsSecretAccessKey"> Secret key element of the AWS credential object (write only). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="awsAccessKeyId"/> or <paramref name="awsSecretAccessKey"/> is null. </exception>
        public AwsCredsAuthenticationDetailsProperties(string awsAccessKeyId, string awsSecretAccessKey)
        {
            Argument.AssertNotNull(awsAccessKeyId, nameof(awsAccessKeyId));
            Argument.AssertNotNull(awsSecretAccessKey, nameof(awsSecretAccessKey));

            AwsAccessKeyId = awsAccessKeyId;
            AwsSecretAccessKey = awsSecretAccessKey;
            AuthenticationType = AuthenticationType.AwsCreds;
        }

        /// <summary> Initializes a new instance of <see cref="AwsCredsAuthenticationDetailsProperties"/>. </summary>
        /// <param name="authenticationProvisioningState"> State of the multi-cloud connector. </param>
        /// <param name="grantedPermissions"> The permissions detected in the cloud account. </param>
        /// <param name="authenticationType"> Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="accountId"> The ID of the cloud account. </param>
        /// <param name="awsAccessKeyId"> Public key element of the AWS credential object (write only). </param>
        /// <param name="awsSecretAccessKey"> Secret key element of the AWS credential object (write only). </param>
        internal AwsCredsAuthenticationDetailsProperties(AuthenticationProvisioningState? authenticationProvisioningState, IReadOnlyList<SecurityCenterCloudPermission> grantedPermissions, AuthenticationType authenticationType, IDictionary<string, BinaryData> serializedAdditionalRawData, string accountId, string awsAccessKeyId, string awsSecretAccessKey) : base(authenticationProvisioningState, grantedPermissions, authenticationType, serializedAdditionalRawData)
        {
            AccountId = accountId;
            AwsAccessKeyId = awsAccessKeyId;
            AwsSecretAccessKey = awsSecretAccessKey;
            AuthenticationType = authenticationType;
        }

        /// <summary> Initializes a new instance of <see cref="AwsCredsAuthenticationDetailsProperties"/> for deserialization. </summary>
        internal AwsCredsAuthenticationDetailsProperties()
        {
        }

        /// <summary> The ID of the cloud account. </summary>
        public string AccountId { get; }
        /// <summary> Public key element of the AWS credential object (write only). </summary>
        public string AwsAccessKeyId { get; set; }
        /// <summary> Secret key element of the AWS credential object (write only). </summary>
        public string AwsSecretAccessKey { get; set; }
    }
}
