// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class AwsCredsAuthenticationDetailsProperties : IUtf8JsonSerializable, IJsonModel<AwsCredsAuthenticationDetailsProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AwsCredsAuthenticationDetailsProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AwsCredsAuthenticationDetailsProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AwsCredsAuthenticationDetailsProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AwsCredsAuthenticationDetailsProperties)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(AccountId))
            {
                writer.WritePropertyName("accountId"u8);
                writer.WriteStringValue(AccountId);
            }
            writer.WritePropertyName("awsAccessKeyId"u8);
            writer.WriteStringValue(AwsAccessKeyId);
            writer.WritePropertyName("awsSecretAccessKey"u8);
            writer.WriteStringValue(AwsSecretAccessKey);
        }

        AwsCredsAuthenticationDetailsProperties IJsonModel<AwsCredsAuthenticationDetailsProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AwsCredsAuthenticationDetailsProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AwsCredsAuthenticationDetailsProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAwsCredsAuthenticationDetailsProperties(document.RootElement, options);
        }

        internal static AwsCredsAuthenticationDetailsProperties DeserializeAwsCredsAuthenticationDetailsProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string accountId = default;
            string awsAccessKeyId = default;
            string awsSecretAccessKey = default;
            AuthenticationProvisioningState? authenticationProvisioningState = default;
            IReadOnlyList<SecurityCenterCloudPermission> grantedPermissions = default;
            AuthenticationType authenticationType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("accountId"u8))
                {
                    accountId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("awsAccessKeyId"u8))
                {
                    awsAccessKeyId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("awsSecretAccessKey"u8))
                {
                    awsSecretAccessKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("authenticationProvisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    authenticationProvisioningState = new AuthenticationProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("grantedPermissions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SecurityCenterCloudPermission> array = new List<SecurityCenterCloudPermission>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new SecurityCenterCloudPermission(item.GetString()));
                    }
                    grantedPermissions = array;
                    continue;
                }
                if (property.NameEquals("authenticationType"u8))
                {
                    authenticationType = new AuthenticationType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AwsCredsAuthenticationDetailsProperties(
                authenticationProvisioningState,
                grantedPermissions ?? new ChangeTrackingList<SecurityCenterCloudPermission>(),
                authenticationType,
                serializedAdditionalRawData,
                accountId,
                awsAccessKeyId,
                awsSecretAccessKey);
        }

        BinaryData IPersistableModel<AwsCredsAuthenticationDetailsProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AwsCredsAuthenticationDetailsProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AwsCredsAuthenticationDetailsProperties)} does not support writing '{options.Format}' format.");
            }
        }

        AwsCredsAuthenticationDetailsProperties IPersistableModel<AwsCredsAuthenticationDetailsProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AwsCredsAuthenticationDetailsProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAwsCredsAuthenticationDetailsProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AwsCredsAuthenticationDetailsProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AwsCredsAuthenticationDetailsProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
