// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]. </summary>
    public readonly partial struct AutomationTriggeringRulePropertyType : IEquatable<AutomationTriggeringRulePropertyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutomationTriggeringRulePropertyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutomationTriggeringRulePropertyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StringValue = "String";
        private const string IntegerValue = "Integer";
        private const string NumberValue = "Number";
        private const string BooleanValue = "Boolean";

        /// <summary> String. </summary>
        public static AutomationTriggeringRulePropertyType String { get; } = new AutomationTriggeringRulePropertyType(StringValue);
        /// <summary> Integer. </summary>
        public static AutomationTriggeringRulePropertyType Integer { get; } = new AutomationTriggeringRulePropertyType(IntegerValue);
        /// <summary> Number. </summary>
        public static AutomationTriggeringRulePropertyType Number { get; } = new AutomationTriggeringRulePropertyType(NumberValue);
        /// <summary> Boolean. </summary>
        public static AutomationTriggeringRulePropertyType Boolean { get; } = new AutomationTriggeringRulePropertyType(BooleanValue);
        /// <summary> Determines if two <see cref="AutomationTriggeringRulePropertyType"/> values are the same. </summary>
        public static bool operator ==(AutomationTriggeringRulePropertyType left, AutomationTriggeringRulePropertyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutomationTriggeringRulePropertyType"/> values are not the same. </summary>
        public static bool operator !=(AutomationTriggeringRulePropertyType left, AutomationTriggeringRulePropertyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutomationTriggeringRulePropertyType"/>. </summary>
        public static implicit operator AutomationTriggeringRulePropertyType(string value) => new AutomationTriggeringRulePropertyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutomationTriggeringRulePropertyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutomationTriggeringRulePropertyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
