// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType. </summary>
    public readonly partial struct AutomationTriggeringRuleOperator : IEquatable<AutomationTriggeringRuleOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutomationTriggeringRuleOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutomationTriggeringRuleOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualsValueValue = "Equals";
        private const string GreaterThanValue = "GreaterThan";
        private const string GreaterThanOrEqualToValue = "GreaterThanOrEqualTo";
        private const string LesserThanValue = "LesserThan";
        private const string LesserThanOrEqualToValue = "LesserThanOrEqualTo";
        private const string NotEqualsValue = "NotEquals";
        private const string ContainsValue = "Contains";
        private const string StartsWithValue = "StartsWith";
        private const string EndsWithValue = "EndsWith";

        /// <summary> Applies for decimal and non-decimal operands. </summary>
        public static AutomationTriggeringRuleOperator EqualsValue { get; } = new AutomationTriggeringRuleOperator(EqualsValueValue);
        /// <summary> Applies only for decimal operands. </summary>
        public static AutomationTriggeringRuleOperator GreaterThan { get; } = new AutomationTriggeringRuleOperator(GreaterThanValue);
        /// <summary> Applies only for decimal operands. </summary>
        public static AutomationTriggeringRuleOperator GreaterThanOrEqualTo { get; } = new AutomationTriggeringRuleOperator(GreaterThanOrEqualToValue);
        /// <summary> Applies only for decimal operands. </summary>
        public static AutomationTriggeringRuleOperator LesserThan { get; } = new AutomationTriggeringRuleOperator(LesserThanValue);
        /// <summary> Applies only for decimal operands. </summary>
        public static AutomationTriggeringRuleOperator LesserThanOrEqualTo { get; } = new AutomationTriggeringRuleOperator(LesserThanOrEqualToValue);
        /// <summary> Applies  for decimal and non-decimal operands. </summary>
        public static AutomationTriggeringRuleOperator NotEquals { get; } = new AutomationTriggeringRuleOperator(NotEqualsValue);
        /// <summary> Applies only for non-decimal operands. </summary>
        public static AutomationTriggeringRuleOperator Contains { get; } = new AutomationTriggeringRuleOperator(ContainsValue);
        /// <summary> Applies only for non-decimal operands. </summary>
        public static AutomationTriggeringRuleOperator StartsWith { get; } = new AutomationTriggeringRuleOperator(StartsWithValue);
        /// <summary> Applies only for non-decimal operands. </summary>
        public static AutomationTriggeringRuleOperator EndsWith { get; } = new AutomationTriggeringRuleOperator(EndsWithValue);
        /// <summary> Determines if two <see cref="AutomationTriggeringRuleOperator"/> values are the same. </summary>
        public static bool operator ==(AutomationTriggeringRuleOperator left, AutomationTriggeringRuleOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutomationTriggeringRuleOperator"/> values are not the same. </summary>
        public static bool operator !=(AutomationTriggeringRuleOperator left, AutomationTriggeringRuleOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutomationTriggeringRuleOperator"/>. </summary>
        public static implicit operator AutomationTriggeringRuleOperator(string value) => new AutomationTriggeringRuleOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutomationTriggeringRuleOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutomationTriggeringRuleOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
