// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Describes what kind of security agent provisioning action to take. </summary>
    public readonly partial struct AutoProvisionState : IEquatable<AutoProvisionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutoProvisionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutoProvisionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnValue = "On";
        private const string OffValue = "Off";

        /// <summary> Install missing security agent on VMs automatically. </summary>
        public static AutoProvisionState On { get; } = new AutoProvisionState(OnValue);
        /// <summary> Do not install security agent on the VMs automatically. </summary>
        public static AutoProvisionState Off { get; } = new AutoProvisionState(OffValue);
        /// <summary> Determines if two <see cref="AutoProvisionState"/> values are the same. </summary>
        public static bool operator ==(AutoProvisionState left, AutoProvisionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutoProvisionState"/> values are not the same. </summary>
        public static bool operator !=(AutoProvisionState left, AutoProvisionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutoProvisionState"/>. </summary>
        public static implicit operator AutoProvisionState(string value) => new AutoProvisionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutoProvisionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutoProvisionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
