// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials. </summary>
    internal readonly partial struct AuthenticationType : IEquatable<AuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AwsCredsValue = "awsCreds";
        private const string AwsAssumeRoleValue = "awsAssumeRole";
        private const string GcpCredentialsValue = "gcpCredentials";

        /// <summary> AWS cloud account connector user credentials authentication. </summary>
        public static AuthenticationType AwsCreds { get; } = new AuthenticationType(AwsCredsValue);
        /// <summary> AWS account connector assume role authentication. </summary>
        public static AuthenticationType AwsAssumeRole { get; } = new AuthenticationType(AwsAssumeRoleValue);
        /// <summary> GCP account connector service to service authentication. </summary>
        public static AuthenticationType GcpCredentials { get; } = new AuthenticationType(GcpCredentialsValue);
        /// <summary> Determines if two <see cref="AuthenticationType"/> values are the same. </summary>
        public static bool operator ==(AuthenticationType left, AuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(AuthenticationType left, AuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AuthenticationType"/>. </summary>
        public static implicit operator AuthenticationType(string value) => new AuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
