// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The external security solution properties for ATA solutions. </summary>
    public partial class AtaSolutionProperties : ExternalSecuritySolutionProperties
    {
        /// <summary> Initializes a new instance of <see cref="AtaSolutionProperties"/>. </summary>
        public AtaSolutionProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AtaSolutionProperties"/>. </summary>
        /// <param name="deviceVendor"></param>
        /// <param name="deviceType"></param>
        /// <param name="workspace"> Represents an OMS workspace to which the solution is connected. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="lastEventReceived"></param>
        internal AtaSolutionProperties(string deviceVendor, string deviceType, WritableSubResource workspace, IDictionary<string, BinaryData> additionalProperties, string lastEventReceived) : base(deviceVendor, deviceType, workspace, additionalProperties)
        {
            LastEventReceived = lastEventReceived;
        }

        /// <summary> Gets or sets the last event received. </summary>
        public string LastEventReceived { get; set; }
    }
}
