// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Sub-assessment resource type. </summary>
    internal readonly partial struct AssessedResourceType : IEquatable<AssessedResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AssessedResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AssessedResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlServerVulnerabilityValue = "SqlServerVulnerability";
        private const string ContainerRegistryVulnerabilityValue = "ContainerRegistryVulnerability";
        private const string ServerVulnerabilityValue = "ServerVulnerability";

        /// <summary> SqlServerVulnerability. </summary>
        public static AssessedResourceType SqlServerVulnerability { get; } = new AssessedResourceType(SqlServerVulnerabilityValue);
        /// <summary> ContainerRegistryVulnerability. </summary>
        public static AssessedResourceType ContainerRegistryVulnerability { get; } = new AssessedResourceType(ContainerRegistryVulnerabilityValue);
        /// <summary> ServerVulnerability. </summary>
        public static AssessedResourceType ServerVulnerability { get; } = new AssessedResourceType(ServerVulnerabilityValue);
        /// <summary> Determines if two <see cref="AssessedResourceType"/> values are the same. </summary>
        public static bool operator ==(AssessedResourceType left, AssessedResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AssessedResourceType"/> values are not the same. </summary>
        public static bool operator !=(AssessedResourceType left, AssessedResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AssessedResourceType"/>. </summary>
        public static implicit operator AssessedResourceType(string value) => new AssessedResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AssessedResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AssessedResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
