// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary>
    /// Configuration of PR Annotations on default branch.
    ///
    /// Enabled - PR Annotations are enabled on the resource's default branch.
    /// Disabled - PR Annotations are disabled on the resource's default branch.
    /// </summary>
    public readonly partial struct AnnotateDefaultBranchState : IEquatable<AnnotateDefaultBranchState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnnotateDefaultBranchState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnnotateDefaultBranchState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static AnnotateDefaultBranchState Disabled { get; } = new AnnotateDefaultBranchState(DisabledValue);
        /// <summary> Enabled. </summary>
        public static AnnotateDefaultBranchState Enabled { get; } = new AnnotateDefaultBranchState(EnabledValue);
        /// <summary> Determines if two <see cref="AnnotateDefaultBranchState"/> values are the same. </summary>
        public static bool operator ==(AnnotateDefaultBranchState left, AnnotateDefaultBranchState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnnotateDefaultBranchState"/> values are not the same. </summary>
        public static bool operator !=(AnnotateDefaultBranchState left, AnnotateDefaultBranchState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnnotateDefaultBranchState"/>. </summary>
        public static implicit operator AnnotateDefaultBranchState(string value) => new AnnotateDefaultBranchState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnnotateDefaultBranchState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnnotateDefaultBranchState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
