// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Workspace type. </summary>
    public readonly partial struct AdditionalWorkspaceType : IEquatable<AdditionalWorkspaceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AdditionalWorkspaceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AdditionalWorkspaceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SentinelValue = "Sentinel";

        /// <summary> Sentinel. </summary>
        public static AdditionalWorkspaceType Sentinel { get; } = new AdditionalWorkspaceType(SentinelValue);
        /// <summary> Determines if two <see cref="AdditionalWorkspaceType"/> values are the same. </summary>
        public static bool operator ==(AdditionalWorkspaceType left, AdditionalWorkspaceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AdditionalWorkspaceType"/> values are not the same. </summary>
        public static bool operator !=(AdditionalWorkspaceType left, AdditionalWorkspaceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AdditionalWorkspaceType"/>. </summary>
        public static implicit operator AdditionalWorkspaceType(string value) => new AdditionalWorkspaceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AdditionalWorkspaceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AdditionalWorkspaceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
