// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Data types sent to workspace. </summary>
    public readonly partial struct AdditionalWorkspaceDataType : IEquatable<AdditionalWorkspaceDataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AdditionalWorkspaceDataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AdditionalWorkspaceDataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AlertsValue = "Alerts";
        private const string RawEventsValue = "RawEvents";

        /// <summary> Alerts. </summary>
        public static AdditionalWorkspaceDataType Alerts { get; } = new AdditionalWorkspaceDataType(AlertsValue);
        /// <summary> RawEvents. </summary>
        public static AdditionalWorkspaceDataType RawEvents { get; } = new AdditionalWorkspaceDataType(RawEventsValue);
        /// <summary> Determines if two <see cref="AdditionalWorkspaceDataType"/> values are the same. </summary>
        public static bool operator ==(AdditionalWorkspaceDataType left, AdditionalWorkspaceDataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AdditionalWorkspaceDataType"/> values are not the same. </summary>
        public static bool operator !=(AdditionalWorkspaceDataType left, AdditionalWorkspaceDataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AdditionalWorkspaceDataType"/>. </summary>
        public static implicit operator AdditionalWorkspaceDataType(string value) => new AdditionalWorkspaceDataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AdditionalWorkspaceDataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AdditionalWorkspaceDataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
